/*
 * Copyright (c) 2004 John Topley (www.johntopley.com)
 * Project      : Web Forum
 * File         : PostsDAO.java
 * Classes      : PostsDAO 
 */
package com.johntopley.webforum.data;

import com.johntopley.webforum.data.BaseDAO;
import com.johntopley.webforum.model.Post;
import com.johntopley.webforum.model.Posts;
import com.johntopley.webforum.model.User;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import java.util.Date;

import javax.naming.NamingException;

/**
 * Data Access Object for <code>Post</code> and <code>Posts</code> objects.
 * 
 * @author John Topley
 * @version 1.0
 * 
 * @see com.johntopley.webforum.model.Post
 * @see com.johntopley.webforum.model.Posts
 */
public class PostsDAO extends BaseDAO
{
  /**
   * No argument constructor for creating a new <code>PostsDAO</code>. Calls
   * the superclass constructor.
   * 
   * @throws NamingException if thrown by the superclass.
   * 
   * @see com.johntopley.webforum.data.BaseDAO#BaseDAO()
   */
  public PostsDAO() throws NamingException
  {
    super();
  }  

  /**
   * Gets the collection of topics.
   * 
   * @return a <code>Posts</code> object containing the topics.
   * @throws NamingException if thrown by the <code>UsersDAO</code> constructor.
   * @throws SQLException if the topics could not be retrieved.
   * 
   * @see com.johntopley.webforum.data.UsersDAO#UsersDAO()
   */
  public Posts getTopics() throws NamingException, SQLException
  {
    Connection conn = null;
    Statement stmt = null;
    ResultSet rset = null;
    Posts topics = new Posts();

    StringBuffer sql = new StringBuffer();
    sql.append("SELECT   p.PostID ")
       .append("       , p.Subject ")
       .append("       , p.ReplyCount ")
       .append("       , p.UserID ")
       .append("       , p.CreationDate ")
       .append("FROM     Posts p ")
       .append("WHERE    p.ParentID = 0 ")
       .append("ORDER BY p.CreationDate DESC");
    
    try
    {
      conn = super.getConnection();
      stmt = conn.createStatement();
      rset = stmt.executeQuery(sql.toString());

      while (rset.next())
      {
        Long postID = new Long(rset.getLong("p.PostID"));
        String subject = rset.getString("p.Subject");
        Long replyCount = new Long(rset.getLong("p.ReplyCount"));
        Long userID = new Long(rset.getLong("p.UserID"));

        UsersDAO usersDAO = new UsersDAO();        
        User user = usersDAO.getUser(userID);
        String author = user.getDisplayName();       
          
        Date creationDate
          = new Date(rset.getTimestamp("p.CreationDate").getTime());

        Post post = new Post(postID.toString(),
                             subject,
                             replyCount.toString(),
                             author,
                             creationDate);
                             
        topics.addPost(post);
      }      
    }    
    finally
    {
      super.closeResources(rset, stmt, conn);
    }

    return topics;
  }
}